<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClubsTable extends Migration {

	public function up()
	{
		Schema::create('clubs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nom_club', 100);
			$table->text('description')->nullable();
			$table->integer('pays_id')->unsigned()->index();
			$table->integer('ville_id')->unsigned()->index();
			$table->date('date_creation')->nullable();
			$table->string('logo')->nullable();
			$table->integer('nb_vues')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('clubs');
	}
}