<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJoueursTable extends Migration {

	public function up()
	{
		Schema::create('joueurs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nom_club', 100);
			$table->string('prenom', 100)->nullable();
			$table->mediumInteger('pays_id')->unsigned()->index();
			$table->string('photo')->nullable();
			$table->date('date_naissance')->nullable();
			$table->string('poste', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('joueurs');
	}
}