<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRetailerTable extends Migration {

	public function up()
	{
		Schema::create('Retailer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->mediumText('description');
			$table->string('city', 100);
			$table->integer('distance');
			$table->string('email', 150);
			$table->string('fax', 150);
			$table->string('googlemappostcode', 150);
			$table->string('gssnId', 150);
			$table->enum('IsNewCarRetailer', array('false', 'true'));
			$table->enum('isonline', array('false', 'true'));
			$table->enum('IsUsedCarRetailer', array('false', 'true'));
			$table->double('Latitude');
			$table->double('Longitude');
			$table->string('PaymentServiceGuid', 150);
			$table->string('Phone', 150);
			$table->string('Postcode', 60);
			$table->enum('ReservationsEnabled', array('false', 'true'));
			$table->string('RetailerGroupId', 150);
			$table->string('RetailerGroupName', 150);
			$table->string('Street', 150);
			$table->string('Website', 150);
		});
	}

	public function down()
	{
		Schema::drop('Retailer');
	}
}