<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('tipo', 1)->default('0');
			$table->string('cnpj', 14);
			$table->string('cpf', 11);
			$table->string('nome', 100);
			$table->string('razao_social', 100);
			$table->string('nome_fantasia', 100);
			$table->string('profile_img');
			$table->string('telefone', 14);
			$table->string('telefone_comercial', 14);
			$table->string('celular', 14);
			$table->bigInteger('endereco_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}