<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'email', 'password');
    protected $hidden = array('password', 'rememberToken');

    public function roles()
    {
        return $this->belongsToMany('App\Models\Role');
    }

    public function players()
    {
        return $this->hasOne('App\Models\Player', 'user_id');
    }

    public function skills()
    {
        return $this->hasOne('App\Models\Skill', 'user_id');
    }

    public function doctors()
    {
        return $this->hasOne('App\Models\Doctor', 'user_id');
    }

    public function guardian()
    {
        return $this->hasMany('App\Models\Guardian', 'user_id');
    }

}