<?php

namespace App\User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'User';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function UserOwnsHost()
	{
		return $this->hasMany('Hosts');
	}

	public function UserHasAccessInScansHost()
	{
		return $this->hasOne('Scans');
	}

}