<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('description', 255);
			$table->text('content');
			$table->string('slug')->unique();
			$table->string('post_img');
			$table->boolean('is_active')->nullable()->index()->default(0);
			$table->boolean('is_featured')->nullable()->index()->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}