<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAisAirportRunwayTable extends Migration {

	public function up()
	{
		Schema::create('ais_airport_runway', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('airport_id')->unsigned();
			$table->integer('recipricol_id')->unsigned();
			$table->string('identifier', 3);
			$table->smallInteger('course')->unsigned();
			$table->smallInteger('elevation')->unsigned();
			$table->decimal('longitude', 12,8);
			$table->decimal('latitude', 12,8);
			$table->boolean('ils');
			$table->smallInteger('ils_course')->unsigned();
			$table->decimal('ils_freq', 6,3);
			$table->smallInteger('ils_glidepath')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ais_airport_runway');
	}
}