<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeconsTable extends Migration {

	public function up()
	{
		Schema::create('lecons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('achat_id')->unsigned();
			$table->integer('horaire_id')->unsigned()->nullable();
			$table->datetime('date');
			$table->enum('etat', array('Pris', 'Abs', 'absdu', 'Offert'));
			$table->string('commentaire', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lecons');
	}
}