<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForfaitsTable extends Migration {

	public function up()
	{
		Schema::create('forfaits', function(Blueprint $table) {
			$table->increments('id');
			$table->text('nom');
			$table->float('prix');
			$table->integer('nombre_cours');
			$table->enum('type', array('adulte', 'enfant', 'stage_enfant', 'stage_adulte'));
			$table->tinyInteger('delais_mois');
			$table->tinyInteger('delais_semaine');
			$table->datetime('delais_date');
			$table->tinyInteger('officiel')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('forfaits');
	}
}