<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDirectionsTable extends Migration {

	public function up()
	{
		Schema::create('directions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('atelier_id')->unsigned()->nullable();
			$table->string('nom', 191);
			$table->string('prenom', 191);
			$table->enum('role', array('superadmin', 'responsable', 'directeur'));
			$table->string('password', 191);
			$table->string('email', 191);
			$table->integer('telephone');
			$table->integer('telephoneportable')->nullable();
			$table->text('adresse')->nullable();
			$table->string('code_postal', 5)->nullable();
			$table->string('ville', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('directions');
	}
}