<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TeamPerson extends Eloquent {

	protected $table = 'team_persons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'position_ar', 'position_en', 'desc_ar', 'desc_en', 'image', 'team_id');
	protected $visible = array('name_ar', 'name_en', 'position_ar', 'position_en', 'desc_ar', 'desc_en', 'image', 'team_id');

	public function team()
	{
		return $this->belongsTo('App\Models\Team', 'team_id');
	}

}