<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Team extends Eloquent {

	protected $table = 'teams';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en', 'image');
	protected $visible = array('name_ar', 'name_en', 'image');

	public function persons()
	{
		return $this->hasMany('App\Models\TeamPerson', 'team_id');
	}

}