<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_ar', 'name_en');
	protected $visible = array('name_ar', 'name_en');

	public function works()
	{
		return $this->hasMany('App\Models\Work', 'category_id');
	}

}