<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamPersonsTable extends Migration {

	public function up()
	{
		Schema::create('team_persons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('name_ar');
			$table->text('name_en');
			$table->string('position_ar');
			$table->string('position_en');
			$table->text('desc_ar');
			$table->text('desc_en');
			$table->string('image', 191)->nullable();
			$table->integer('team_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('team_persons');
	}
}