<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdmin3CodesTable extends Migration {

	public function up()
	{
		Schema::create('admin3_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('code', 20)->unique();
			$table->string('admin2_code', 20)->index();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admin3_codes');
	}
}