<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostalCodesTable extends Migration {

	public function up()
	{
		Schema::create('postal_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('code', 20)->index();
			$table->string('country_code', 2)->index();
			$table->string('admin1_code', 20);
			$table->string('admin2_code', 20);
			$table->string('admin3_code', 20);
			$table->decimal('latitude', 10,8)->nullable();
			$table->decimal('longitude', 11,8)->nullable();
			$table->smallInteger('status')->unsigned()->index()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('postal_codes');
	}
}