<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityNaturalIdentificationsTable extends Migration {

	public function up()
	{
		Schema::create('entity_natural_identifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('entity_natural_id')->unsigned();
			$table->string('country_code', 2);
			$table->integer('identification_type_id')->unsigned();
			$table->string('number', 50)->index();
			$table->date('from_at')->nullable();
			$table->date('to_at')->nullable();
			$table->string('issue_place')->nullable();
			$table->smallInteger('lifetime')->unsigned()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('entity_natural_identifications');
	}
}