<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('user_id', true);
			$table->string('name', 20);
			$table->string('email', 40)->unique()->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('password', 255)->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->string('type', 10);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}