<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Date extends Eloquent {

	protected $table = 'dates';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('event_id', 'date');

	public function events()
	{
		return $this->belongsTo('Event');
	}

	public function venues()
	{
		return $this->hasOne('Venue');
	}

}