<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'last_name', 'mobile', 'email', 'password');

	public function addresses()
	{
		return $this->hasMany('Address', 'client_id');
	}

}