<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Address extends Eloquent {

	protected $table = 'address';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'address');

	public function client()
	{
		return $this->belongsTo('Client', 'client_id');
	}

}