<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReportsTable extends Migration {

	public function up()
	{
		Schema::create('reports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('reportable_type');
			$table->integer('reportable_id');
			$table->longText('report');
			$table->enum('status', array('pending', 'done'));
			$table->datetime('recheck_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reports');
	}
}