<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('reservation_id', true);
			$table->string('reservation_code')->unique();
			$table->integer('ticket_category_id')->unsigned();
			$table->integer('no_of_audience')->unsigned();
			$table->integer('status')->default('1');
			$table->integer('booked_user_id')->unsigned();
			$table->integer('checked_user_id')->unsigned();
			$table->integer('checked_status')->unsigned()->default('0');
			$table->timestamp('checked_date');
			$table->decimal('amount', 12,2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}