<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAudiencesTable extends Migration {

	public function up()
	{
		Schema::create('audiences', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->integer('age');
			$table->string('sex');
			$table->text('address');
			$table->integer('reservation_id')->unsigned();
			$table->string('email_id')->unique();
			$table->string('phone_no')->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('audiences');
	}
}