<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->string('name');
			$table->string('slug', 10);
			$table->string('hex_color', 6);
			$table->string('type', 10);
			$table->integer('trust_id')->unsigned();
			$table->tinyInteger('sso')->nullable();
			$table->string('sso_ip_range_start')->nullable();
			$table->string('sso_ip_range_end')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}