<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->string('remember_token')->nullable();
			$table->integer('unique_id')->unsigned();
			$table->tinyInteger('active');
			$table->integer('impersonate')->unsigned()->default('0');
			$table->text('ad_groups');
			$table->datetime('sync');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}