<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSafeguardingLogsTable extends Migration {

	public function up()
	{
		Schema::create('safeguarding_logs', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->integer('site_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->string('student_name');
			$table->date('dob');
			$table->string('class');
			$table->string('time_of_incident');
			$table->text('incident_details');
			$table->text('further_info');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('safeguarding_logs');
	}
}