<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name');
			$table->integer('country_id')->unsigned();
			$table->date('birth_date');
			$table->string('email');
			$table->string('phone_number');
			$table->enum('gender', array('male', 'female'));
			$table->integer('client_id')->unsigned();
			$table->integer('member_relation_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}