<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone_number');
			$table->string('email');
			$table->string('first_name');
			$table->string('last_name');
			$table->integer('country_id')->unsigned();
			$table->enum('gender', array('male', 'female'));
			$table->string('password');
			$table->integer('activation_code');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}