<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImportantDatesTable extends Migration {

	public function up()
	{
		Schema::create('important_dates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->datetimeTz('start_date');
			$table->datetimeTz('end_date');
			$table->integer('repeat_no');
			$table->string('repeat_type');
			$table->date('repeat_end_date');
			$table->integer('category_id')->unsigned();
			$table->integer('color_id')->unsigned();
			$table->string('notes')->nullable();
			$table->integer('is_end');
			$table->integer('family_member_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('important_dates');
	}
}