<?php

namespace app\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('role_id', 'username', 'password', 'first_name', 'last_name', 'email');
	protected $hidden = array('password');

	public function groups()
	{
		return $this->belongsToMany('app\Models\Group');
	}

}