<?php

namespace app\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'service';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('group_id', 'name', 'notes', 'price', 'iva');

	public function group()
	{
		return $this->belongsTo('app\Models\Group', 'group_id');
	}

}