<?php

namespace app\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Program extends Eloquent {

	protected $table = 'program';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function students()
	{
		return $this->hasMany('app\Models\Student', 'student_id');
	}

}