<?php

namespace app\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InvoiceItem extends Eloquent {

	protected $table = 'invoice_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('quantity', 'total', 'invoice_id', 'service_id', 'period');

	public function service()
	{
		return $this->hasOne('app\Models\Service', 'service_id');
	}

}