<?php

namespace app\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoice';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nit_ci', 'tr', 'notes', 'total', 'paid', 'authorization_number', 'percentage_discount', 'total_discount', 'percentage_taxes', 'total_taxes', 'control_code', 'total_literal', 'status_id', 'client_id', 'user_id', 'student_id', 'group_id', 'patient_id');

	public function items()
	{
		return $this->hasMany('app\Models\InvoiceItem', 'invoice_id');
	}

	public function status()
	{
		return $this->hasOne('app\Models\InvoiceStatus', 'status_id');
	}

	public function client()
	{
		return $this->belongsTo('app\Models\Client', 'client_id');
	}

	public function user()
	{
		return $this->belongsTo('app\Models\User', 'user_id');
	}

	public function group()
	{
		return $this->belongsTo('app\Models\Group', 'group_id');
	}

}