<?php

namespace app\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('ci', 'name', 'address', 'phone', 'mobile', 'email', 'notes', 'user_id');

	public function user()
	{
		return $this->belongsTo('app\Models\User', 'user_id');
	}

}