<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('role')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('invoice_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('group')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoice_item', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoice')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoice_item', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('service')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('service', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('group')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('group')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('program_student', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('program')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('program_student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('student')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('client', function(Blueprint $table) {
			$table->dropForeign('client_user_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_status_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_client_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_user_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_student_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_group_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_patient_id_foreign');
		});
		Schema::table('invoice_item', function(Blueprint $table) {
			$table->dropForeign('invoice_item_invoice_id_foreign');
		});
		Schema::table('invoice_item', function(Blueprint $table) {
			$table->dropForeign('invoice_item_service_id_foreign');
		});
		Schema::table('service', function(Blueprint $table) {
			$table->dropForeign('service_group_id_foreign');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->dropForeign('group_user_user_id_foreign');
		});
		Schema::table('group_user', function(Blueprint $table) {
			$table->dropForeign('group_user_group_id_foreign');
		});
		Schema::table('program_student', function(Blueprint $table) {
			$table->dropForeign('program_student_program_id_foreign');
		});
		Schema::table('program_student', function(Blueprint $table) {
			$table->dropForeign('program_student_student_id_foreign');
		});
	}
}