<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceItemTable extends Migration {

	public function up()
	{
		Schema::create('invoice_item', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('quantity');
			$table->decimal('total');
			$table->integer('invoice_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->string('period')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoice_item');
	}
}