<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->string('ci', 255)->unique();
			$table->string('name', 255);
			$table->text('address')->nullable();
			$table->string('phone', 100)->nullable();
			$table->string('mobile', 100)->nullable();
			$table->string('email', 255)->nullable();
			$table->text('notes')->nullable();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}