<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nit_ci')->nullable();
			$table->string('tr')->nullable();
			$table->text('notes')->nullable();
			$table->decimal('total');
			$table->decimal('paid')->nullable();
			$table->string('authorization_number', 255)->nullable();
			$table->integer('percentage_discount')->nullable();
			$table->decimal('total_discount');
			$table->integer('percentage_taxes');
			$table->decimal('total_taxes');
			$table->string('control_code')->unique()->nullable();
			$table->string('total_literal')->nullable();
			$table->integer('status_id')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('student_id')->unsigned()->nullable();
			$table->integer('group_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}