<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecipientsTable extends Migration {

	public function up()
	{
		Schema::create('recipients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('public_notice_id')->unsigned()->index();
			$table->integer('officer_id')->unsigned()->nullable()->index();
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('title', 255)->nullable();
			$table->enum('type', array('"website"', '"printed_media"', '"school_board_communication"', '"other"'))->nullable();
			$table->integer('order')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('recipients');
	}
}