<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfficersTable extends Migration {

	public function up()
	{
		Schema::create('officers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('district_state_doe', 200)->nullable();
			$table->string('school', 200)->nullable();
			$table->integer('role_id')->unsigned()->nullable();
			$table->tinyInteger('access_level_1')->unsigned()->default('0');
			$table->tinyInteger('access_level_2')->unsigned()->default('0');
			$table->integer('organization_id')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('officers');
	}
}