<?php

class Bid extends Eloquent {

	protected $table = 'bids';
	public $timestamps = true;

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function officer()
	{
		return $this->belongsTo('Officer', 'officer_id');
	}

	public function sections()
	{
		return $this->hasMany('BidSection');
	}

	public function type()
	{
		return $this->belongsTo('Type', 'type_id');
	}

	public function rubric()
	{
		return $this->hasOne('App\EvaluationRubric', 'rubric_id');
	}

}