<?php

namespace User;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('first_name', 'last_name', 'email', 'birthdate', 'password', 'image', 'address', 'job_title', 'user_type', 'status', 'gender');

	public function phone()
	{
		return $this->morphMany('Phone', 'phoneable');
	}

	public function shipments()
	{
		return $this->hasMany('Shipment');
	}

	public function branch()
	{
		return $this->belongsToMany('Branch', 'branch_user', 'user_id', 'branch_id');
	}

}