<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchsTable extends Migration {

	public function up()
	{
		Schema::create('matchs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('match_date');
			$table->integer('equipe_domicile_id')->unsigned();
			$table->integer('equipe_exterieur_id')->unsigned();
			$table->integer('resultat_domicile');
			$table->integer('resultat_exterieur');
			$table->integer('competition_id')->unsigned();
			$table->integer('stade_id')->unsigned();
			$table->boolean('report')->default(0);
			$table->datetime('date_report');
			$table->time('heure_match');
		});
	}

	public function down()
	{
		Schema::drop('matchs');
	}
}