<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Competition extends Model 
{

    protected $table = 'competitions';
    public $timestamps = true;
    protected $fillable = array('libelle_competition');

    public function categorie_age()
    {
        return $this->belongsTo('App\CategorieAge');
    }

    public function matchs()
    {
        return $this->hasMany('App\Match');
    }

    public function responsable()
    {
        return $this->belongsTo('App\Responsable');
    }

    public function saison()
    {
        return $this->belongsTo('App\Saison');
    }

    public function officials()
    {
        return $this->hasMany('App\Official');
    }

}