<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserRewardPointTable extends Migration {

	public function up()
	{
		Schema::create('user_reward_point', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code')->index();
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->double('reward_point', 8,3);
			$table->tinyInteger('reward_type');
			$table->tinyInteger('operation_type');
			$table->datetime('expire_on');
			$table->tinyInteger('status')->default('0');
			$table->softDeletes();
			$table->timestamps();
			$table->string('created_by')->nullable();
			$table->string('updated_by')->nullable();
			$table->string('deleted_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_reward_point');
	}
}