<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('stations_pivot_table', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('stations')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('supports')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('support_threads', function(Blueprint $table) {
			$table->foreign('support_id')->references('id')->on('supports')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('support_threads', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('support_threads', function(Blueprint $table) {
			$table->foreign('receiver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('device_tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('otps', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('vehicle_id')->references('id')->on('vehicles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('station_id')->references('id')->on('stations')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('employe_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('stations', function(Blueprint $table) {
			$table->dropForeign('stations_manager_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_company_id_foreign');
		});
		Schema::table('vehicles', function(Blueprint $table) {
			$table->dropForeign('vehicles_driver_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_manager_id_foreign');
		});
		Schema::table('stations_pivot_table', function(Blueprint $table) {
			$table->dropForeign('stations_pivot_table_station_id_foreign');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->dropForeign('supports_type_id_foreign');
		});
		Schema::table('supports', function(Blueprint $table) {
			$table->dropForeign('supports_user_id_foreign');
		});
		Schema::table('support_threads', function(Blueprint $table) {
			$table->dropForeign('support_threads_support_id_foreign');
		});
		Schema::table('support_threads', function(Blueprint $table) {
			$table->dropForeign('support_threads_sender_id_foreign');
		});
		Schema::table('support_threads', function(Blueprint $table) {
			$table->dropForeign('support_threads_receiver_id_foreign');
		});
		Schema::table('device_tokens', function(Blueprint $table) {
			$table->dropForeign('device_tokens_user_id_foreign');
		});
		Schema::table('otps', function(Blueprint $table) {
			$table->dropForeign('otps_user_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_company_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_vehicle_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_driver_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_station_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_employe_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
	}
}