<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('manager_id')->unsigned()->nullable();
			$table->string('name')->nullable();
			$table->string('manager_name')->nullable();
			$table->string('mobile')->nullable();
			$table->string('another_mobile')->nullable();
			$table->text('notes');
			$table->enum('active', array('1', '0'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}